//
//  GSGlyphViewProtocol.h
//  GlyphsCore
//
//  Created by Georg Seifert on 26.01.10.
//  Copyright 2010 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSGeometrieHelper.h"

typedef enum {
	GSKerningNormal = 1,
	GSKerningContextual = 2
} GSKerningMode;

@class GSLayer;
@class YLTextStorage;
@class YLLayoutManager;

@protocol GSGlyphEditViewProtocol

@property(nonatomic, assign) GSLayer			*activeLayer;
@property(nonatomic) NSPoint					activePosition;
@property(nonatomic) NSUInteger					activeIndex;
@property(nonatomic, readonly) NSUInteger		cachedCount;
@property(nonatomic) NSRange					selectedRange;
@property(nonatomic, readonly) NSRange			cachedSelectionRange;
@property(nonatomic) CGFloat					scale;
@property(nonatomic, retain) NSCursor			*cursor;
//@property(nonatomic, assign) GSLayer			*shadowLayer;
@property(nonatomic) NSRect						glyphFrame;
@property(strong, nonatomic) YLTextStorage*		textStorage;
@property(nonatomic) GSKerningMode				kerningMode;
@property (nonatomic, assign) BOOL				doKerning;
@property(strong, nonatomic) NSAffineTransform	*zoomTransformer;
@property(strong, nonatomic) YLLayoutManager*	layoutManager;
- (NSPoint) getActiveLocation:(NSEvent *)theEvent ;
- (GSLayer*) cachedGlyphAtIndex:(NSUInteger)Index ;
- (NSPoint) cachedPositionAtIndex: (NSUInteger)Index ;
- (NSUInteger) characterIndexForPoint:(NSPoint)thePoint ;
- (void) drawLayer:(GSLayer *) Layer atPoint:(NSPoint) aPoint asActive:(BOOL) Active attributes:(NSDictionary*) Attributes ;
- (NSRect) drawText:(NSString*) Text atPoint:(NSPoint) DrawPoint withColor:(NSColor*) TextColor alignment: (GSAlignment) Alignment ;
- (NSRect) drawText:(NSString*) Text atPoint:(NSPoint) Position withColor:(NSColor*) TextColor ;
- (NSRect) drawText:(NSAttributedString*)AttributedString atPoint:(NSPoint)aPoint alignment:(GSAlignment)Aligment;
- (NSRect) drawBadge:(NSString*) Text atPoint:(NSPoint) DrawPoint alignment: (GSAlignment) Alignment visibleInRect:(NSRect) VisibleRect ;
//- (void) drawBadge:(NSString*) Text atPoint:(NSPoint) DrawPoint alignment: (GSAlignment) Alignment ;
- (void) drawBadge:(NSString*) Text atPoint:(NSPoint) DrawPoint alignment: (GSAlignment) Alignment ;
- (void) reflow;
@end
